k6 `v0.50.0` is here 🎉! 

This release:
- Adds support for uploading files from the browser module.
- Introduces the `options.cloud` option.
- Stabilizes the previously experimental timers module as the `k6/timers` module.
- Brings JSON Web Key support to the `k6/experimental/webcrypto` module.

## Breaking changes

- [websockets#60](https://github.com/grafana/xk6-websockets/pull/60) allows manually setting the `name` tag, which also overwrites the `url` tag with the `name` value. This change makes it consistent with the logic that was implemented in k6 v0.41. Thanks, @mkadirtan for contributing!

### Browser APIs to Async

In future releases, we are going to be moving most of the synchronous browser APIs to asynchronous ones (promisifying them). We expect this will affect most of our users, so we are posting this upfront before making the change. Here are the reasons for making this large breaking change:

1. Most browser APIs use some form of long-running IO operation (networking) to perform the requested action on the web browser against the website under test. We need to avoid blocking JavaScript's runtime event loop for such operations.
2. We're going to add more asynchronous event-based APIs (such as [page.on](https://github.com/grafana/xk6-browser/issues/1227)) that our current synchronous APIs would block.
3. To align with how developers expect to work with JavaScript APIs.
4. To have better compatibility with Playwright.

You can find a list of all the APIs that we expect to convert to async in a comment in issue [browser#428](https://github.com/grafana/xk6-browser/issues/428#issuecomment-1964020837).

Awaiting on something that’s not a thenable just returns that value, which means you can add the `await` keyword against APIs that will become async to future proof your test scripts.

## New features

### Add support for uploading files from the browser module [browser#1097](https://github.com/grafana/xk6-browser/pull/1097), [browser#1244](https://github.com/grafana/xk6-browser/pull/1244)

You can now upload files using the available input forms on the website under test. The new API is `setInputFiles` which can be called from a `page`, `frame` or `elementHandle` types. It can upload one or more files encoded in the test script. To upload files from the local file system, work with the [experimental fs module](https://grafana.com/docs/k6/latest/javascript-api/k6-experimental/fs/).

<details>
<summary>Expand to see the examples.</summary>

For the following examples, we will use the HTML file:

```html
<html>

<body>
    <form method="POST" action="/upload" enctype="multipart/form-data">
        <input type="file" name="upl" id="upload" multiple />
        <input type="submit" value="Send" />
    </form>
</body>

</html>
```

Uploading a file can be achieved with the following script:

```js
// Import the k6 encoder module.
import encoding from 'k6/encoding';
...
export default async function () {
  const page = browser.newPage();

  await page.goto(url)

  // Encode and upload some data into a plain text file called test.txt.
  page.setInputFiles('input[id="upload"]', { name: 'test.txt', mimetype: 'text/plain', buffer: encoding.b64encode('Hello World') })
  
  // Click on the submit button on the form to upload the file.
  const submitButton = page.locator('input[type="submit"]')
  await Promise.all([page.waitForNavigation(), submitButton.click()])

  page.close();
}
```

Uploading multiple files can be done with the use of an array:

```js
page.setInputFiles('input[id="upload"]',
    [{ name: 'test.txt', mimetype: 'text/plain', buffer: encoding.b64encode('Hello World') },
    { name: 'test.json', mimetype: 'text/json', buffer: encoding.b64encode('{"message": "Hello World"}') }])
```

</details>

Thanks to @bandorko! :bow: :tada:

### Introducing options.cloud [#3348](https://github.com/grafana/k6/pull/3348), [#3407](https://github.com/grafana/k6/pull/3407)

In this release, we introduce a new way of defining cloud options. From now on, you can use `options.cloud` instead of `options.ext.loadimpact`. 

To migrate, you can move the `loadimpact` object to the root of the `options` object and rename it to `cloud`. For example:

```javascript
export let options = {
    ext: {
        loadimpact: {
            name: "Legacy way of defining cloud options",
            projectID: 12345,
        }
    }
};

export let options = {
    cloud: {
        name: "Current way of defining cloud options",
        projectID: 12345,
    }
};
```

All scripts with legacy `options.ext.loadimpact` will continue to function as before. There's no planned sunset date for the legacy option, but we highly encourage using `options.cloud` going forward. For more details about cloud options, refer to [Cloud options](https://grafana.com/docs/grafana-cloud/k6/author-run/cloud-scripting-extras/cloud-options/).

### Timers API becomes part of the k6 core [#3587](https://github.com/grafana/k6/pull/3587)

With this release, the timers API is no longer experimental and can be imported as `k6/timers` instead of as `k6/experimental/timers`. The later will be supported until `v0.52.0`.

You can also contribute to the discussion on making the current timer exports globally available in [#3589](https://github.com/grafana/k6/issues/3589), or just give it a :+1:.

### JSON Web Key support in `k6/experimental/webcrypto` module [webcrypto#61](https://github.com/grafana/xk6-webcrypto/pull/61)

The experimental webcrypto module now supports the JSON Web Key (JWK) format, using the `importKey` and `exportKey` methods.

This allows you to import and export keys in the JWK format for the supported algorithms.

```js
const generatedKey = await crypto.subtle.generateKey({name: "AES-CBC", length: "256"}, true, [ "encrypt", "decrypt"]);

const exportedKey = await crypto.subtle.exportKey("jwk", generatedKey);
```

## UX improvements and enhancements

- [browser#1197](https://github.com/grafana/xk6-browser/pull/1197), [browser#1202](https://github.com/grafana/xk6-browser/pull/1202), [browser#1203](https://github.com/grafana/xk6-browser/pull/1203), [browser#1221](https://github.com/grafana/xk6-browser/pull/1221) adds the ability to upload screenshots to a remote location.
- [browser#1209](https://github.com/grafana/xk6-browser/pull/1209) adds a shadow DOM usage example.
- [browser#1233](https://github.com/grafana/xk6-browser/pull/1233) returns actionable errors for `evaluate` APIs.
- [browser#1228](https://github.com/grafana/xk6-browser/pull/1228), [browser#1232](https://github.com/grafana/xk6-browser/pull/1232), [browser#1235](https://github.com/grafana/xk6-browser/pull/1235) injects the `testRunId` into the `window.k6` object for external applications to query (for example, Grafana Faro).

### Browser Context Isolation [browser#1112](https://github.com/grafana/xk6-browser/issues/1112)

With this release, we have overhauled and (tremendously) improved the performance and stability of the browser module. It's now possible to run tests with a larger number of VUs concurrently without any performance issues. Previously, when running tests with multiple VUs concurrently, each VU's browser context would attach to the pages from the other VUs' browser contexts. This led to unexpected behavior and performance issues and, to an extent, reduced the module's capability to run multi-VU tests.

## Bug fixes

- [#3653](https://github.com/grafana/k6/pull/3653) fixes a connectivity issue with non-lowercase `options.hosts`.
- [browser#1215](https://github.com/grafana/xk6-browser/pull/1215) fixes a data race during logging that panics.
- [browser#1238](https://github.com/grafana/xk6-browser/pull/1238) fixes fill functionality for textarea. Thanks @bandorko for the fix! :bow: :tada:
- [browser#1242](https://github.com/grafana/xk6-browser/pull/1242) fixes XPath evaluation on `DocumentFragment`.

## Maintenance and internal improvements

- [browser#1164](https://github.com/grafana/xk6-browser/pull/1164), [browser#1166](https://github.com/grafana/xk6-browser/pull/1166), [browser#1171](https://github.com/grafana/xk6-browser/pull/1171),
  [browser#1173](https://github.com/grafana/xk6-browser/pull/1173), [browser#1175](https://github.com/grafana/xk6-browser/pull/1175), [browser#1179](https://github.com/grafana/xk6-browser/pull/1179),
  [browser#1183](https://github.com/grafana/xk6-browser/pull/1183), [browser#1186](https://github.com/grafana/xk6-browser/pull/1186), [browser#1188](https://github.com/grafana/xk6-browser/pull/1188),
  [browser#1189](https://github.com/grafana/xk6-browser/pull/1189), [browser#1190](https://github.com/grafana/xk6-browser/pull/1190), [browser#1191](https://github.com/grafana/xk6-browser/pull/1191),
  [browser#1193](https://github.com/grafana/xk6-browser/pull/1193), [browser#1163](https://github.com/grafana/xk6-browser/pull/1163), [browser#1205](https://github.com/grafana/xk6-browser/pull/1205),
  [browser#1217](https://github.com/grafana/xk6-browser/pull/1217) refactors internals to improve stability.
- [browser#850](https://github.com/grafana/xk6-browser/pull/850), [browser#1211](https://github.com/grafana/xk6-browser/pull/1211), [browser#1212](https://github.com/grafana/xk6-browser/pull/1212),
  [browser#1214](https://github.com/grafana/xk6-browser/pull/1214), [browser#1216](https://github.com/grafana/xk6-browser/pull/1216) refactors to work with errors.Join and sets the minimum Go version to 1.20.
- [browser#1220](https://github.com/grafana/xk6-browser/pull/1220) adds more logging.
- [browser#1112](https://github.com/grafana/xk6-browser/issues/1112) fixes deadlock issues when running multiple VUs, iterations, and Chrome instances.
- [browser#1246](https://github.com/grafana/xk6-browser/issues/1246) removes logging of in-flight requests when a request fails.
- [#3586](https://github.com/grafana/k6/pull/3586) fixes file traversal for the test.
- [#3588](https://github.com/grafana/k6/pull/3588) updates `codeql` GitHub action to v3.
* [webcrypto#62](https://github.com/grafana/xk6-webcrypto/pull/62) fixes display error message in the console and does minor maintenance.
* [webcrypto#60](https://github.com/grafana/xk6-webcrypto/pull/60) leverages some of the k6 APIs to handle JavaScript operations.
* [webcrypto#59](https://github.com/grafana/xk6-webcrypto/pull/59) makes `newTestSetup` rely on k6's modulestest.
* [webcrypto#58](https://github.com/grafana/xk6-webcrypto/pull/58) addresses linter issues related to repeated static strings.
* [3633](https://github.com/grafana/k6/pull/3633) updates k6 dependencies.
